EmailGenerator = {
    WelcomeMail: () => {
        let subject = Helpers.GetLocalized('welcomemail_subject');
        let message = Helpers.GetLocalized('welcomemail_body');
        GetRootScope().sendMail('Jonas', subject, message);
    },
    EmployeeQuit: (companyName, employee) => {
        let subject = Helpers.GetLocalized('employeequit_subject');
        let message = Helpers.GetLocalized('employeequit_body', { companyName: companyName, employeeTypeName: employee.employeeTypeName, name: employee.name });
        GetRootScope().sendMail(employee.name, subject, message);
    },
    LowMoneyWarning: () => {
        let subject = Helpers.GetLocalized('lowmoneywarning_subject');
        let message = Helpers.GetLocalized('lowmoneywarning_body');
        GetRootScope().sendMail("Nordiwa Banking", subject, message);
    },
    ContractCancel: (product, contract) => {
        let subject = Helpers.GetLocalized('contractcancel_subject');
        let message = Helpers.GetLocalized('contractcancel_body', { number:  contract.number});

        GetRootScope().sendMail(product.name, subject, message);
    },
    LoanCreated: (loan) => {
        let subject = Helpers.GetLocalized('loancreated_subject');
        let message = Helpers.GetLocalized('loancreated_body', { companyName: GetRootScope().settings.companyName, amount: numeral(loan.amount).format(Configuration.CURRENCY_FORMAT), provider: loan.provider });

        GetRootScope().sendMail(loan.provider, subject, message);
    },
    LoanPaidOut: (loan) => {
        let subject = Helpers.GetLocalized('loanpaidout_subject');
        let message = Helpers.GetLocalized('loanpaidout_body', { companyName: GetRootScope().settings.companyName, provider: loan.provider });
        GetRootScope().sendMail(loan.provider, subject, message);
    },
};
